# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuth2Communicator


logger = logging.getLogger('social.broker.communicators')


class MicrosoftCommunicator(OAuth2Communicator):
    OAUTH_ACCESS_TOKEN_URL = 'https://login.live.com/oauth20_token.srf'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'
    OAUTH_AUTHORIZE_URL = 'https://login.live.com/oauth20_authorize.srf?'
    default_scopes = ['wl.basic', 'wl.birthday', 'wl.offline_access', 'wl.emails']
    scope_delimiter = ' '
    provider_code = 'ms'
    REDIRECT_NEEDED = True

    display_map = {
        'page': 'page',
        'popup': 'popup',
        'touch': 'touch',
        'wap': 'touch',
    }
    display_value_if_not_set = 'page'

    def _build_login_hint_args(self, login_hint):
        assert login_hint
        return {'username': login_hint}
