# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from urlparse import urlparse

from passport.backend.social.broker.communicators.communicator import OAuth2CommunicatorWithAbsoluteRedirect
from passport.backend.social.common import oauth2
from passport.backend.social.common.providers.Mts import Mts
from passport.backend.social.common.useragent import Url


def add_to_manager(manager):
    custom_mapping = {'mts_v3': MtsV3Communicator}
    manager.add_mapping(Mts.code, MtsV2Communicator, mapping=custom_mapping)


def _detect_error_in_access_token_response(response):
    if 'error' in response:
        error_code = response['error']
        if error_code == 'invalid_request':
            raise oauth2.token.InvalidGrant()
    oauth2.token.detect_error(response)


class MtsV2Communicator(OAuth2CommunicatorWithAbsoluteRedirect):
    # TODO
    # Поддержать инкрементальные гранты include_granted_scopes=true
    # Поддержать параметр управления запросом approval_prompt=auto

    OAUTH_AUTHORIZE_URL = 'https://login.mts.ru/amserver/oauth2/auth'
    OAUTH_AUTHORIZE_MANDATORY_ARGUMENTS = {
        'access_type': 'offline',
        'auth-service': 'login',
        'sms': 'forced',
        'srcsvc': 'music',
    }
    REDIRECT_NEEDED = True

    OAUTH_ACCESS_TOKEN_URL = 'https://login.mts.ru/amserver/oauth2/token'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    default_scopes = [
        'mobile:phone',
        'mobile:account',
        'profile:avatar',
        'profile:avatar:id',
        'profile:description',
        'profile:premium',
        'sso',
    ]
    scope_delimiter = ' '
    provider_code = 'mt'

    # TODO Поддержать display = touch

    def get_authorize_url(self, *args, **kwargs):
        url = super(MtsV2Communicator, self).get_authorize_url(*args, **kwargs)

        url = urlparse(url)
        goto = url.path
        if url.params:
            goto += ';' + url.params
        if url.query:
            goto += '?' + url.query
        if url.fragment:
            goto += '#' + url.fragment
        url = Url('https://login.mts.ru/amserver/UI/Login')
        url.add_params(
            {
                'access_type': 'offline',
                'auth-service': 'music2',
                'goto': goto,
                'service': 'music2',
            },
        )

        return str(url)

    def _get_error_detector_for_access_token_response(self):
        return _detect_error_in_access_token_response

    def get_real_token_data(self, token, fail_silent=False, need_client_id=True):
        return self._get_real_token_data(token, fail_silent=fail_silent, need_client_id=need_client_id)

    def check_token(self, token):
        return self._check_token(token)


class MtsV3Communicator(OAuth2CommunicatorWithAbsoluteRedirect):
    OAUTH_AUTHORIZE_URL = 'https://login.mts.ru/amserver/oauth2/realms/root/realms/users/authorize'
    REDIRECT_NEEDED = True

    OAUTH_ACCESS_TOKEN_URL = 'https://login.mts.ru/amserver/oauth2/realms/root/realms/users/access_token'
    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    default_scopes = [
        'account',
        'phone',
        'profile',
        'sso',
    ]
    scope_delimiter = ' '
    provider_code = 'mt'

    def check_token(self, token):
        # МТС не предоставляет инфу о токене
        pass
