# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuth2Communicator
from passport.backend.social.broker.exceptions import (
    CommunicationFailedError,
    UserDeniedError,
)
from passport.backend.social.common import oauth2


logger = logging.getLogger('social.broker.communicators')


def _detect_error_in_access_token_response(response):
    if 'error' in response:
        error_code = response['error']
        if error_code == 'invalid_token':
            raise oauth2.token.InvalidGrant()

    try:
        oauth2.token.detect_error(response)
    except oauth2.token.InvalidRequest:
        raise oauth2.token.InvalidGrant()


class OdnoklassnikiCommunicator(OAuth2Communicator):
    OAUTH_ACCESS_TOKEN_URL = 'https://api.odnoklassniki.ru/oauth/token.do'
    OAUTH_AUTHORIZE_URL = 'https://www.odnoklassniki.ru/oauth/authorize'
    provider_code = 'ok'
    REDIRECT_NEEDED = True

    ACCESS_TOKEN_REQUEST_TYPE = 'POST'
    default_scopes = ['VALUABLE_ACCESS']
    scope_delimiter = ';'

    display_parameter_name = 'layout'
    display_value_if_not_set = None
    display_map = {
        'page': None,
        'popup': None,
        'touch': 'm',
        'wap': 'm',
    }

    def has_error_in_callback(self, query, *args, **kwargs):
        error_name = query.get('error')
        if error_name:
            if error_name == 'access_denied':
                raise UserDeniedError('User denied access')
            raise CommunicationFailedError('Error in callback: ' + str(query['error']))

    def _get_error_detector_for_access_token_response(self):
        return _detect_error_in_access_token_response
