# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import Communicator
from passport.backend.social.broker.misc import b64u_encode
from passport.backend.social.common.misc import urlencode


logger = logging.getLogger('social.broker.communicators')


class TelegramCommunicator(Communicator):
    provider_code = 'tg'
    BASE_URL = 'https://telegram.me'

    def get_authorize_url(self, options):
        logger.debug('Getting authorize redirect url...')

        bot = options.client_id or self.app.id
        args = {
            'mode': 'bind',
            'redirect_uri': options.callback_url,
        }
        start = b64u_encode(urlencode(args))
        query = 'start=' + start

        result = '{base}/{bot}?{query}'.format(base=self.BASE_URL, bot=bot, query=query)

        return result
