# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuthCommunicator


logger = logging.getLogger('social.broker.communicators')


class TwitterCommunicator(OAuthCommunicator):
    """
    Twitter OAuth authentication.
    """
    OAUTH_REQUEST_TOKEN_URL = 'https://api.twitter.com/oauth/request_token'
    OAUTH_ACCESS_TOKEN_URL = 'https://api.twitter.com/oauth/access_token'
    OAUTH_AUTHORIZE_URL = 'https://api.twitter.com/oauth/authorize'
    OAUTH_AUTHENTICATE_URL = 'https://api.twitter.com/oauth/authenticate'

    REQUEST_METHOD = 'POST'

    provider_code = 'tw'

    default_scopes = ['read']
    scope_name = 'x_auth_access_type'

    def check_token(self, token):
        # Здесь не требуется проверка client_id токена, т.к. на каждый запрос
        # вместе с токеном в Twitter отправляется и предпологаемый client_id,
        # а затем Twitter сам проверяет их соответствие.
        return
