# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging

from passport.backend.social.broker.communicators.communicator import OAuth2Communicator
from passport.backend.social.broker.exceptions import (
    CommunicationFailedError,
    UserDeniedError,
)


logger = logging.getLogger('social.broker.communicators')


class VkontakteCommunicator(OAuth2Communicator):
    OAUTH_ACCESS_TOKEN_URL = 'https://oauth.vk.com/access_token'
    OAUTH_AUTHORIZE_URL = 'https://oauth.vk.com/authorize'
    provider_code = 'vk'
    REDIRECT_NEEDED = True
    OAUTH_AUTHORIZE_MANDATORY_ARGUMENTS = {'v': '5.131'}

    default_scopes = ['email', 'offline']

    display_map = dict([(x, x) for x in OAuth2Communicator.display_map])

    _force_prompt_args = {'revoke': '1'}

    def has_error_in_callback(self, query, *args, **kwargs):
        error_name = query.get('error')
        if error_name:
            if error_name == 'access_denied':
                raise UserDeniedError('User denied access')
            raise CommunicationFailedError('Error in callback: "%s": "%s"' + str(query['error']))

    def get_real_token_data(self, token, fail_silent=False, need_client_id=True):
        return self._get_real_token_data(token, fail_silent=fail_silent, need_client_id=need_client_id)

    def check_token(self, token):
        return self._check_token(token)

    def parse_access_token(self, response):
        token = super(VkontakteCommunicator, self).parse_access_token(response)

        # Для ВК email приходит в access_token при авторизации. PASSP-18588
        parsed_response = json.loads(response)
        if parsed_response.get('email'):
            token['extra_userinfo'] = {'email': parsed_response['email']}

        return token
