# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.broker.communicators.communicator import OAuth2CommunicatorWithAbsoluteRedirect
from passport.backend.social.broker.exceptions import OAuthTokenInvalidError
from passport.backend.social.common.builders.blackbox import (
    BlackboxOauthTokenInvalidError,
    check_token_suitable_for_binding,
)
from passport.backend.social.common.providers.Yandex import Yandex
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.token.domain import Token


logger = logging.getLogger('social.broker.communicators')


class YandexCommunicator(OAuth2CommunicatorWithAbsoluteRedirect):
    @property
    def OAUTH_AUTHORIZE_URL(self):
        return social_config.yandex_oauth_authorize_url

    REDIRECT_NEEDED = True

    @property
    def OAUTH_ACCESS_TOKEN_URL(self):
        return social_config.yandex_oauth_token_url

    ACCESS_TOKEN_REQUEST_TYPE = 'POST'

    provider_code = Yandex.code

    def get_real_token_data(self, token, fail_silent=False, need_client_id=True):
        return self._get_real_token_data(token, fail_silent=fail_silent, need_client_id=need_client_id)

    def check_token(self, token):
        client_id = token['client_id']
        token = Token.from_dict_for_proxy(token)
        try:
            check_token_suitable_for_binding(token, client_id)
        except BlackboxOauthTokenInvalidError as e:
            raise OAuthTokenInvalidError(str(e))

    def _build_login_hint_args(self, login_hint):
        return {'login_hint': login_hint}
