# -*- coding: utf-8 -*-

from datetime import datetime
import json
import logging

from passport.backend.social.broker.exceptions import SessionInvalidError
from passport.backend.social.common.chrono import now
from passport.backend.social.common.misc import (
    format_traceback,
    get_future_timestamp,
)
from passport.backend.social.common.social_config import social_config
from werkzeug.contrib.securecookie import SecureCookie


logger = logging.getLogger(__name__)


def decrypt_cookie(cookie):
    try:
        cookie_data = JSONSecureCookie.unserialize(cookie, social_config.track_cookie_secure_key)
        logger.debug('Parsing cookie data')
        json_data = cookie_data.get('value')

        logger.debug('Checking cookie expiration time')

        expires = cookie_data['expires']
        expires = datetime.fromtimestamp(expires)
        _now = now()
    except Exception:
        # TODO
        # Сузить множество исключений
        logger.warning('Error while parsing cookie: %s', format_traceback())
        raise SessionInvalidError('Can not parse cookie data')

    if expires < _now:
        raise SessionInvalidError('Session expired')
    return json_data


def build_json_secure_cookie(value, expires_in):
    expires_at = get_future_timestamp(expires_in)
    cookie = JSONSecureCookie(
        dict(
            value=value,
            expires=expires_at,
        ),
        social_config.track_cookie_secure_key,
    )
    return cookie.serialize()


class JSONSecureCookie(SecureCookie):
    serialization_method = json
