# -*- coding: utf-8 -*-

from __future__ import absolute_import

from multiprocessing import cpu_count
import sys

from passport.backend.social.common.gunicorn import Application
from passport.backend.social.common.importer import (
    install_file_system_importer,
    install_python_path2,
)
import yenv


name = 'social-broker'

bind = [
    'unix:/tmp/yandex-%s.sock' % name,
]

ip_addr = '127.0.0.1:6000'
if yenv.type == 'development':
    ip_addr = '[::]:6000'
bind.append(ip_addr)

cfg = dict(
    bind=bind,
    app_uri='passport.backend.social.broker.wsgi:app',
    worker_class='passport.backend.social.common.gunicorn.GeventWorker',
    errorlog='/var/log/yandex/socialism/%s.gunicorn.error.log' % name,
    accesslog='/var/log/yandex/socialism/%s.gunicorn.access.log' % name,
    loglevel='INFO',
    workers=cpu_count(),
    timeout=30,
    max_requests=50100,
)


def main():
    install_python_path2()
    install_file_system_importer()
    sys.exit(Application(cfg).run())


if __name__ == '__main__':
    main()
