# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from passport.backend.social.broker.exceptions import PkceVerifierInvalidError
from passport.backend.social.broker.handlers.base import Handler
from passport.backend.social.common.pkce import (
    check_pkce,
    PkceInvalidCodeVerifierError,
)


class CheckPkceHandler(Handler):
    def get(self):
        self.check_grant('check-pkce')

        self.process_args()

        self.task_id = self.processed_args['task_id']
        self.update_task_from_redis()

        self.check_pkce(
            self.processed_args['code_verifier'],
            self.task.code_challenge,
            self.task.code_challenge_method,
        )

        return self.compose_response()

    def process_args(self):
        processor = self.build_request_processor()
        processor.process_task_id()
        processor.process_pkce_verifier(required=False)
        self.processed_args.update(processor.processed_args)

    def check_pkce(self, verifier, challenge, challenge_method):
        try:
            check_pkce(verifier, challenge, challenge_method, allow_empty=True)
        except PkceInvalidCodeVerifierError:
            raise PkceVerifierInvalidError()

    def compose_response(self):
        self.response.data = self.compose_json_response(dict(status='ok'))
        return self.response
