# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.broker.handlers.profile.base import NativeProfileHandler
from passport.backend.social.common.builders.passport import Passport
from passport.backend.social.common.token.domain import Token
from passport.backend.social.common.useragent import get_http_pool_manager


class BindByTokenHandler(NativeProfileHandler):
    """
    По токену от социального провайдера определяется социальный аккаунт и
    привязывается к яндексовому.
    """
    def get(self):
        self.check_grant('bind-by-token')

        self.init_new_task()
        self.process_bind_by_token_args()
        self.log_that_request_is_ok()

        self.fill_task_with_processed_args()

        self.get_authorization(
            frontend_hostname=None,
            session_id=None,
            oauth_token=self.processed_args['oauth_token'],
            require_auth=True,
        )

        app = self.processed_args['application']
        token = Token(
            application_id=app.identifier,
            value=self.processed_args['provider_token'],
            secret=self.processed_args['provider_token_secret'],
            scopes=self.processed_args['scope'],
            expired=None,
            created=None,
            verified=None,
            confirmed=None,
        )
        self.get_profile_native(app, token)

        self.bind_profile(has_profile=True, sid=self.processed_args['sid'])
        self.compose_profile_response(
            self.processed_args['return_brief_profile'],
            self.processed_args['retpath'],
            self.processed_args['place'],
        )
        self.send_notifications()
        return self.response

    def send_notifications(self):
        passport = Passport(get_http_pool_manager())
        passport.send_account_modification_notifications(
            self.processed_args['hostname'],
            self.processed_args['user_ip'],
            self.task.uid,
            'social_add',
            social_provider=self.processed_args['provider']['name'],
        )

    def process_bind_by_token_args(self):
        processor = self.build_request_processor()

        # retpath и place нужно парсить одним из первых, т.к. туда фронт будет
        # направлять веб-клиент пользователя в случаях отказа.
        processor.process_consumer()
        processor.process_retpath()
        processor.fix_morda_retpath()
        processor.process_place()
        self.processed_args.update(processor.processed_args)

        processor.process_frontend_url()
        processor.process_hostname_and_tld(processor.processed_args['frontend_url'])
        self.processed_args.update(processor.processed_args)

        processor.process_yandex_token()
        processor.process_user_ip()

        processor.get_bool('return_brief_profile')
        processor.process_app_and_provider(processor.processed_args['tld'])
        processor.process_provider_token()
        processor.process_place()
        processor.process_consumer()
        processor.process_retpath()
        processor.fix_morda_retpath()
        processor.process_sid()

        self.processed_args.update(processor.processed_args)

        self.processed_args['display'] = None

    def fill_task_with_processed_args(self):
        self.task.consumer = self.processed_args['consumer']
        self.task.provider = self.processed_args['provider']
        self.task.application = self.processed_args['application']
        self.task.sid = self.processed_args['sid']
        self.task.access_token = {
            'value': self.processed_args['provider_token'],
            'secret': self.processed_args['provider_token_secret'],
            'scope': self.processed_args['scope'],
        }

    @property
    def consumer(self):
        return self._get_consumer_from_headers()
