# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging

from passport.backend.social.broker.handlers.profile.base import NativeProfileHandler
from passport.backend.social.common.token.domain import Token


logger = logging.getLogger(__name__)


class TaskByTokenHandler(NativeProfileHandler):
    def get(self):
        self.check_grant('task-by-token')

        self.init_new_task()
        self.process_task_by_token_args()
        self.log_that_request_is_ok()

        self.fill_task_with_processed_args()

        app = self.processed_args['application']
        token = Token(
            application_id=app.identifier,
            value=self.processed_args['provider_token'],
            secret=self.processed_args['provider_token_secret'],
            scopes=self.processed_args['scope'],
            expired=None,
            created=None,
            verified=None,
            confirmed=None,
        )
        self.get_profile_native(app, token)

        task_dict = self.task.get_dict_for_response(
            with_related_yandex_client_secret=self.consumer_has_grant('related-yandex-client-secret'),
        )
        self.response.data = json.dumps(task_dict) + '\n'
        return self.response

    def process_task_by_token_args(self):
        processor = self.build_request_processor()

        processor.process_app_and_provider(tld='ru')
        processor.process_provider_token()
        processor.process_consumer()

        self.processed_args.update(processor.processed_args)

        self.processed_args['display'] = None
        self.processed_args['tld'] = 'ru'

    def fill_task_with_processed_args(self):
        self.task.consumer = self.processed_args['consumer']
        self.task.provider = self.processed_args['provider']
        self.task.application = self.processed_args['application']
        self.task.access_token = {
            'value': self.processed_args['provider_token'],
            'secret': self.processed_args['provider_token_secret'],
            'scope': self.processed_args['scope'],
        }
