# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import json
import logging

from passport.backend.social.broker.communicators.TwitterCommunicator import TwitterCommunicator
from passport.backend.social.broker.exceptions import (
    ApplicationUnknownError,
    CommunicationFailedError,
)
from passport.backend.social.broker.handlers.args_processor import ArgsProcessor
from passport.backend.social.broker.handlers.base import Handler
from passport.backend.social.common.providers.Twitter import Twitter
from passport.backend.social.proxylib import useragent


logger = logging.getLogger()


class TwitterReverseAuthTokenHandler(Handler):
    def get(self):
        self.check_grant('twitter-reverse-auth-token')

        self.init_new_task()

        self.process_tw_reverse_auth_token_args()
        self.log_that_request_is_ok()

        app = self.processed_args['application']
        if app.provider['code'] != Twitter.code:
            raise ApplicationUnknownError()

        self.communicator = TwitterCommunicator(app, self.processed_args['display'])

        url, body, headers = self.communicator.get_request_token_url(
            method='POST',
            data={'x_auth_mode': 'reverse_auth'},
        )
        response = useragent.execute_request(
            method='POST',
            url=url,
            fields=body,
            headers=headers,
            retries=self.communicator.retries,
            timeout=self.communicator.timeout,
            request_signer=self.communicator.get_request_signer(oauth_callback=self.task_id),
            from_intranet=app.request_from_intranet_allowed,
            service=app.provider['code'],
        )
        if response.status != 200:
            return CommunicationFailedError(response.data)

        self.response.data = json.dumps({
            'x_reverse_auth_target': self.processed_args['application'].id,
            'x_reverse_auth_parameters': response.data,
        })
        return self.response

    def process_tw_reverse_auth_token_args(self):
        processor = ArgsProcessor(
            args=self.request.args,
            form=self.request.form,
            log_actions=True,
        )

        processor.process_app_and_provider(tld='ru')
        processor.process_display()
        processor.process_consumer()

        self.processed_args.update(processor.processed_args)

    @property
    def consumer(self):
        return self._get_consumer_from_headers()
