# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from passport.backend.social.common.fraud import is_fraud_string
from passport.backend.social.common.misc import trim_message
from passport.backend.social.common.provider_settings import get_profile_addresses
from passport.backend.social.proxylib import get_proxy


logger = logging.getLogger(__name__)


def get_social_userinfo(app, token, extra_userinfo=None, user_ip=None,
                        should_retry_on_invalid_token=False):
    logger.info('Requesting a profile information')

    token_dict = token.to_dict_for_proxy()
    aux_data = {'user_ip': user_ip} if user_ip else None
    proxy = get_proxy(
        app.provider['code'],
        token_dict,
        app,
        aux_data,
        should_retry_on_invalid_token=should_retry_on_invalid_token,
    )
    userinfo = proxy.get_profile()

    if extra_userinfo:
        userinfo.update(extra_userinfo)

    userinfo['links'] = get_profile_addresses(
        app.provider['id'],
        str(userinfo.get('userid')),
        userinfo.get('username'),
    )

    lastname = userinfo.get('lastname')
    if lastname:
        # схлопываем группы пробелов
        userinfo['lastname'] = ' '.join(lastname.split())

    userinfo['provider'] = app.provider

    for attr in ['username', 'firstname', 'lastname']:
        if userinfo.get(attr):
            if is_fraud_string(userinfo[attr]):
                logger.debug('Clean up fraud %s: %s' % (attr, trim_message(userinfo[attr])))
                del userinfo[attr]

    return userinfo
