# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.social.common.chrono import now


MASK_TASK_ID = '99999999999999999999999999999999'


class StatboxLogEntry(TskvLogEntry):
    def __init__(self, **params):
        params.setdefault('tskv_format', 'social-broker-log')
        params.setdefault('unixtime', now.i())
        super(StatboxLogEntry, self).__init__(**params)


class LongStatboxLogEntry(StatboxLogEntry):
    @staticmethod
    def truncate_str(text):
        # В некоторых полях находятся списки большой длины, поэтому обрезать их
        # нельзя.
        return text


class StatboxLogger(TskvLogger):
    default_logger_name = 'statbox'
    entry_class = StatboxLogEntry


class LongStatboxLogger(TskvLogger):
    default_logger_name = 'statbox'
    entry_class = LongStatboxLogEntry


def to_statbox(events):
    if 'task_id' in events:
        events = dict(events)
        events['task_id'] = MASK_TASK_ID
    StatboxLogger().log(**events)
