PY2_LIBRARY()

NEED_REVIEW()
OWNER(g:passport_python)

PEERDIR(
    contrib/python/Flask
    contrib/python/furl
    contrib/python/gevent
    contrib/python/Parsley
    contrib/python/Werkzeug
    library/python/yenv

    passport/backend/core/avatars
    passport/backend/social/common
    passport/backend/social/proxylib
    passport/backend/utils/gost/jwt
)

NO_CHECK_IMPORTS(
    passport.backend.social.broker.wsgi
)

PY_SRCS(
    app.py
    avatars.py
    binding.py
    communicators/AmediatekaCommunicator.py
    communicators/AppleCommunicator.py
    communicators/communicator.py
    communicators/DeezerCommunicator.py
    communicators/DnevnikRuCommunicator.py
    communicators/EsiaCommunicator.py
    communicators/FacebookCommunicator.py
    communicators/GoogleCommunicator.py
    communicators/__init__.py
    communicators/LastFmCommunicator.py
    communicators/MailRuCommunicator.py
    communicators/MeethueCommunicator.py
    communicators/MicrosoftCommunicator.py
    communicators/MosRuCommunicator.py
    communicators/MtsBelarusCommunicator.py
    communicators/MtsCommunicator.py
    communicators/OdnoklassnikiCommunicator.py
    communicators/TelegramCommunicator.py
    communicators/TwitterCommunicator.py
    communicators/VkontakteCommunicator.py
    communicators/XiaomiCommunicator.py
    communicators/YahooCommunicator.py
    communicators/YandexCommunicator.py
    cookies.py
    domain.py
    error_handler.py
    exceptions.py
    failure_diagnostics.py
    gunicorn_app.py
    handlers/args_processor.py
    handlers/base.py
    handlers/check_pkce.py
    handlers/create_task_for_profile.py
    handlers/__init__.py
    handlers/ping.py
    handlers/profile/authz_in_web.py
    handlers/profile/base.py
    handlers/profile/bind_by_token.py
    handlers/profile/bind_kinopoisk_account.py
    handlers/profile/bind_phonish_account_by_track.py
    handlers/profile/bind_phonish_account_by_uid.py
    handlers/profile/bind_yandex_account.py
    handlers/profile/does_binding_exist.py
    handlers/profile/__init__.py
    handlers/profile/task_by_token.py
    handlers/profile/task_state.py
    handlers/redirect.py
    handlers/test/create_task.py
    handlers/test/__init__.py
    handlers/token/authz_in_app.py
    handlers/token/authz_in_web.py
    handlers/token/base.py
    handlers/token/__init__.py
    handlers/token/task_state.py
    handlers/tw_reverse_auth_token.py
    __init__.py
    logging_settings.py
    misc.py
    social_userinfo.py
    statbox.py
    test.py
    wsgi.py
)

END()


RECURSE(
    bin/dev_server
    bin/gunicorn
    dev
)


RECURSE_FOR_TESTS(
    tests
)
