# -*- coding: utf-8 -*-

from __future__ import (
    absolute_import,
    unicode_literals,
)

import logging

from passport.backend.core.builders.kolmogor import (
    exceptions as passport_exceptions,
    Kolmogor as _Kolmogor,
)
from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.core.logging_utils.loggers.graphite import GraphiteLogger
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.useragent import UserAgent


SOCIALISM_KOLMOGOR_NAMESPACE = 'socialism'


class Kolmogor(_Kolmogor):
    def __init__(self, http_pool_manager=None):
        url = social_config.kolmogor_url
        retries = social_config.kolmogor_retries
        timeout = social_config.kolmogor_timeout

        useragent = UserAgent(
            # BaseBuilder переопределяет допустимое время на каждый вызов
            timeout=timeout,
            # BaseBuilder делает повторные попытки сам
            retries=1,
            pool_manager=http_pool_manager,
            in_passport_builder=True,
        )

        graphite_logger = GraphiteLogger(
            logging.getLogger('graphite.useragent'),
            service='kolmogor',
        )

        super(Kolmogor, self).__init__(
            url=url,
            useragent=useragent,
            timeout=timeout,
            retries=retries,
            graphite_logger=graphite_logger,
        )


KolmogorPermanentError = passport_exceptions.KolmogorPermanentError
KolmogorTemporaryError = passport_exceptions.KolmogorTemporaryError


def get_kolmogor():
    return LazyLoader.get_instance('kolmogor')
