# -*- coding: utf-8 -*-

import time

from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.utils.time import round_timestamp


def get_chrono():
    return LazyLoader.get_instance('chrono')


def now(tz=None):
    return get_chrono().now(tz=tz)


def _nowf():
    return datetime_to_unixtimef(now())

now.f = _nowf


def _nowi():
    return datetime_to_unixtime(now())

now.i = _nowi


def datetime_to_unixtimef(dt):
    try:
        return time.mktime(dt.timetuple()) + 1e-6 * dt.microsecond
    except AttributeError:
        raise TypeError('datetime_to_unixtimef expects datetime object, got %r instead' % dt)


def datetime_to_unixtime(dt):
    try:
        return int(round_timestamp(time.mktime(dt.timetuple())))
    except AttributeError:
        raise TypeError('datetime_to_unixtime expects datetime object, got %r instead' % dt)
