# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.social_config import social_config


def get_custom_consumer_for_counters(consumer):
    return social_config.consumer_translation_for_counters.get(consumer, consumer)


class CounterDescriptor(object):
    name = None
    limit = None


class CreateApplicationByIpCounterDescriptor(CounterDescriptor):
    def __init__(self, ip):
        self.name = 'create_application_by_ip:' + str(ip)
        self.limit = social_config.counter_limit_for_create_application_by_ip


class ProcessRequestByConsumerCounterDescriptor(CounterDescriptor):
    def __init__(self, request_name, consumer):
        key = (consumer, request_name)
        self.name = 'process_request_by_consumer:%s:%s' % key
        self.limit = social_config.counter_limit_for_process_request_by_consumer.get(key)
