# -*- coding: utf-8 -*-

from cryptography.hazmat.backends.openssl.backend import Backend as OpensslBackend
from passport.backend.utils.gost.cryptography import (
    GostBackendMixin,
    GostR3411_2012_256,
    GostR3411_2012_512,
)
from passport.backend.utils.pkcs7 import (
    Certificates,
    pkcs7_verify,
    Pkcs7VerifyError,
)


_social_cryptography_backend = None


def get_social_cryptography_backend():
    global _social_cryptography_backend
    if _social_cryptography_backend is None:
        _social_cryptography_backend = SocialCryptographyBackend()
    return _social_cryptography_backend


class SocialCryptographyBackend(GostBackendMixin, OpensslBackend):
    pass


__all__ = globals().keys() + [
    'Certificates',
    'GostR3411_2012_256',
    'GostR3411_2012_512',
    'pkcs7_verify',
    'Pkcs7VerifyError',
]
