# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import os
import sys

from passport.backend.social.common.importer import (
    install_file_system_importer,
    install_python_path2,
)


def run_dev(module, default_port):
    prepare_environment(module)

    port = default_port
    if len(sys.argv) == 2:
        port = int(sys.argv[1])

    app = module.create_app()
    app.run(debug=False, host='::', port=port)


def append_python_path2(path):
    old_path = os.environ.get('PYTHONPATH2', '')
    if old_path:
        path = ':'.join([old_path, path])
    os.environ['PYTHONPATH2'] = path


def prepare_environment(module):
    append_python_path2('file::///usr/lib/yandex/socialism')

    install_python_path2()
    install_file_system_importer()

    module.prepare_interprocess_environment()
    module.prepare_intraprocess_environment()
