# -*- coding: utf-8 -*-

from passport.backend.core.builders.blackbox import exceptions as blackbox_exceptions
from passport.backend.social.common.context import request_ctx
from passport.backend.social.common.exception import FailureSourceType
from passport.backend.social.common.misc import (
    GraphiteMessageType,
    name_for_graph_log,
    write_graph_log_message,
)


class ErrorHandler(object):
    def __init__(self, exception):
        self._exception = exception

    def exception_to_response(self):
        raise NotImplementedError()  # pragma: no cover

    def exception_to_graphite(self):
        error_type = self._exception_to_error_type()

        if error_type == FailureSourceType.not_error:
            return

        write_graph_log_message(
            GraphiteMessageType.error,
            self._get_handler_id(),
            self._get_application_descriptor_code(),
            error_type,
        )

    def _get_handler_id(self):
        return request_ctx.handler_id

    def _get_application_descriptor_code(self):
        code = name_for_graph_log(request_ctx.application)
        if not code and request_ctx.provider:
            code = request_ctx.provider['code']
        return code

    def _exception_to_error_type(self):
        error_type = getattr(self._exception, 'failure_source_type', None)
        if error_type:
            return error_type

        if isinstance(
            self._exception,
            (
                blackbox_exceptions.BlackboxInvalidResponseError,
                blackbox_exceptions.BlackboxTemporaryError,
                blackbox_exceptions.BlackboxUnknownError,
            ),
        ):
            return FailureSourceType.network
        return FailureSourceType.internal
