# -*- coding: utf-8 -*-
"""
GPT -- GotoProfileToken
"""

from __future__ import unicode_literals

from hashlib import md5
from time import time

from passport.backend.social.common.random import get_randomizer


class Gpt(object):
    def __init__(self, timer=None, randomizer=None):
        if timer is None:
            timer = time
        if randomizer is None:
            randomizer = get_randomizer()
        self._timer = timer
        self._randomizer = randomizer

    def encode(self, profile_id, uid):
        timestamp = str(int(self._timer()))
        salt = str(self._randomizer.randrange(100000))
        public = '.'.join([timestamp, salt, str(profile_id)])
        signature = self.calc_signature(public, uid)
        token = '.'.join([public, signature])
        return token

    def parse(self, token):
        try:
            public, signature = token.rsplit('.', 1)
            _, profile_id = public.rsplit('.', 1)
            profile_id = int(profile_id)
        except ValueError:
            raise GptParseError()
        return public, profile_id, signature

    def calc_signature(self, public, uid):
        private = '.'.join([public, str(uid)])
        hasher = md5()
        hasher.update(private)
        return hasher.hexdigest()


class GptError(Exception):
    pass


class GptParseError(GptError):
    pass
