import imp
import os
import sys


FILE_SYSTEM_SCHEMA = 'file://'


def install_file_system_importer():
    sys.path_hooks.append(FileSystemImporter)


def install_python_path2():
    python_path = os.environ.get('PYTHONPATH2', '')
    python_path = PythonPathParser().parse(python_path)
    for path_bit in reversed(python_path):
        sys.path.insert(0, path_bit)


class FileSystemImporter(object):
    def __init__(self, path):
        if not path.startswith(FILE_SYSTEM_SCHEMA):
            raise ImportError()
        self.path = path[len(FILE_SYSTEM_SCHEMA):]
        self._found_filenames = dict()

    def find_module(self, fullname, path=None):
        for filename in self._to_filenames(fullname):
            if os.access(filename, os.R_OK):
                self._found_filenames[fullname] = filename
                return self

    def load_module(self, fullname):
        if fullname in sys.modules:
            return sys.modules[fullname]
        module = imp.new_module(fullname)
        sys.modules[fullname] = module
        try:
            filename = self._found_filenames[fullname]
            module.__file__ = filename
            module.__loader__ = self
            if filename.endswith('__init__.py'):
                module.__package__ = fullname
                module.__path__ = [os.path.dirname(filename)]
            else:
                module.__package__ = fullname.rpartition('.')[0]
            exec(open(filename), module.__dict__)
        except:
            del sys.modules[fullname]
            raise
        return module

    def _to_filenames(self, fullname):
        bits = fullname.split('.')
        return [
            os.path.abspath(
                os.path.join(
                    self.path,
                    os.sep.join(bits),
                    '__init__.py',
                ),
            ),
            os.path.abspath(
                os.path.join(self.path, os.sep.join(bits)) + '.py',
            ),
        ]


class PythonPathParser(object):
    def parse(self, python_path):
        path_bits = list()
        i = 0
        while i < len(python_path):
            path_bit, i = self._scan_path_bit(python_path, i)
            path_bit = path_bit.replace('::', ':')
            path_bits.append(path_bit)
            if i < len(python_path):
                if python_path[i] == ':':
                    i += 1
                else:
                    raise NotImplementedError()
        return path_bits

    def _scan_path_bit(self, s, start):
        i = start
        end = False
        while not end:
            if i < len(s):
                if s[i] == ':':
                    if i + 1 < len(s):
                        if s[i + 1] != ':':
                            end = True
                        else:
                            i += 2
                    else:
                        end = True
                else:
                    i += 1
            else:
                end = True
        return s[start:i], i
