# -*- coding: utf-8 -*-

from passport.backend.core.lazy_loader import LazyLoader


DEFAULT_QLIMIT = 100


def get_qlimits():
    return LazyLoader.get_instance('qlimits')


class QLimits(dict):
    def __missing__(self, item):
        return DEFAULT_QLIMIT

    def get(self, item, default=DEFAULT_QLIMIT):
        return super(QLimits, self).get(item, default)
