# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging
from os import environ
import socket

from passport.backend.core.lazy_loader import LazyLoader
import pympler.tracker
from werkzeug.serving import (
    BaseWSGIServer,
    WSGIRequestHandler,
)
from werkzeug.wrappers import (
    Request,
    Response,
)


logger = logging.getLogger(__name__)


def create_memory_profiler():
    if environ.get('SOCIALISM_MEMORY_PROFILER'):
        return pympler.tracker.SummaryTracker()


def get_memory_profiler():
    return LazyLoader.get_instance('memory_profiler')


def start_memory_profiler():
    profiler = get_memory_profiler()
    if profiler:
        emitter = _Emitter(profiler, '127.0.0.1', 16385)
        try:
            emitter.run()
        except socket.error as e:
            logger.debug('Failed to start memory profiler: %s' % e)


class _Emitter(object):
    def __init__(self, memory_profiler, host, port):
        self.memory_profiler = memory_profiler
        self.host = host
        self.port = port

    def handle_request(self, environ, start_response):
        lines = self.memory_profiler.format_diff()
        response = Response('\n'.join(lines) + '\n')
        return response(environ, start_response)

    def run(self):
        server = BaseWSGIServer(self.host, self.port, self.handle_request, _QuietHandler)
        server.log = lambda *args, **kwargs: None
        logger.info('Serving memory profiler on port %s' % self.port)
        server.serve_forever()


class _QuietHandler(WSGIRequestHandler):
    def log_request(self, *args, **kwargs):
        """Suppress request logging so as not to pollute application logs."""
