# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.core import Undefined
from passport.backend.core.models.base import Model as _Model


class Model(_Model):
    def _parse(self, data, fields=None):
        fields = self._meta.filter_fields(fields)
        changed = False
        for key in fields:
            flag, value = self._meta.fields[key].parse(data, self, getattr(self, key, None))
            if flag:
                changed = True
                setattr(self, key, value)
            else:
                old_value = getattr(self, key)
                if value is None:
                    value = Undefined
                setattr(self, key, old_value or value)
        return changed, self
