# -*- coding: utf-8 -*-

from __future__ import unicode_literals


class BaseOauthException(Exception):
    error = None

    def __init__(self, *args):
        super(BaseOauthException, self).__init__(*args)
        self.error_description = None
        self.error_uri = None

    @classmethod
    def from_exception(cls, other):
        self = cls(*other.args)
        self.error_description = other.error_description
        self.error_uri = other.error_uri
        return self


class UnexpectedException(BaseOauthException):
    pass


# Т.к. в разных сценариях один и тот же код ошибки описан по разному, здесь
# вводятся только базовые исключения, конкретные же описаны в соответствующих
# классах.

class BaseInvalidRequest(BaseOauthException):
    error = 'invalid_request'


class BaseInvalidClient(BaseOauthException):
    error = 'invalid_client'


class BaseInvalidGrant(BaseOauthException):
    error = 'invalid_grant'


class BaseUnauthorizedClient(BaseOauthException):
    error = 'unauthorized_client'


class BaseUnsupportedGrantType(BaseOauthException):
    error = 'unsupported_grant_type'


class BaseInvalidScope(BaseOauthException):
    error = 'invalid_scope'


class HttpRequest(object):
    def __init__(self, method, endpoint, query=None, data=None, headers=None):
        self.method = method
        self.endpoint = endpoint
        self.query = query or {}
        self.data = data or {}
        self.headers = headers or {}

    def __repr__(self):
        return (
            '<HttpRequest: method=%s, endpoint=%s, query=%s, data=%s, headers=%s>' % (
                self.method,
                self.endpoint,
                self._repr_dict(self.query),
                self._repr_dict(self.data),
                self._repr_dict(self.headers),
            )
        )

    def _repr_dict(self, _dict):
        bits = []
        for k, v in _dict.iteritems():
            if v is not None:
                bits.append("'%s': '%s'" % (k, v))
            else:
                bits.append("'%s': None" % k)
        value = ','.join(bits)
        return '{%s}' % value
