# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import base64

from . import refresh_token
from .base import (
    HttpRequest,
    UnexpectedException,
)


InvalidRequest = refresh_token.InvalidRequest
InvalidClient = refresh_token.InvalidClient
InvalidGrant = refresh_token.InvalidGrant
UnauthorizedClient = refresh_token.UnauthorizedClient
UnsupportedGrantType = refresh_token.UnsupportedGrantType
InvalidScope = refresh_token.InvalidScope

detect_error = refresh_token.detect_error


def build_authorization_code_request(endpoint, code, client_id=None,
                                     client_secret=None, redirect_uri=None,
                                     http_method='POST'):
    args = {
        'grant_type': 'authorization_code',
        'code': code,
    }
    if client_id is not None:
        args['client_id'] = client_id
    if client_secret is not None:
        args['client_secret'] = client_secret
    if redirect_uri is not None:
        args['redirect_uri'] = redirect_uri
    if http_method == 'POST':
        query = {}
        data = args
        headers = {
            'Content-Type': 'application/x-www-form-urlencoded',
        }
    else:
        query = args
        data = {}
        headers = {}
    return HttpRequest(http_method, endpoint, query, data, headers)


def build_authorization_code_request_basic_auth(endpoint, code, client_id, client_secret, redirect_uri=None,
                                                http_method='POST'):
    headers = {
        'Authorization': 'Basic %s' % (base64.b64encode('%s:%s' % (client_id, client_secret))),
    }
    args = {
        'grant_type': 'authorization_code',
        'code': code,
    }
    if redirect_uri is not None:
        args['redirect_uri'] = redirect_uri
    if http_method == 'POST':
        query = args
        data = args
        headers['Content-Type'] = 'application/x-www-form-urlencoded'
    else:
        query = args
        data = {}
    return HttpRequest(http_method, endpoint, query, data, headers)


__all__ = ['UnexpectedException']
