# -*- coding: utf-8 -*-

import logging

from passport.backend.core.types.account.account import uid_to_kpid
from passport.backend.social.common.providers.provider import Provider
from passport.backend.social.common.social_config import social_config


logger = logging.getLogger(__name__)


class Kinopoisk(Provider):
    code = 'kp'
    id = 24

    @classmethod
    def profile_link(cls, userid=None, username=None, profile_id=None, uid=None):
        links = []
        if userid:
            try:
                kpid = uid_to_kpid(int(userid))
            except ValueError:
                logger.debug('Failed to translate uid to kpid: %s' % userid)
            else:
                links.append('https://%s/user/%s/' % (social_config.kinopoisk_host, kpid))
        return links
