# -*- coding: utf-8 -*-

from passport.backend.social.common.fix_lastfm import (
    fix_lastfm_userid,
    is_broken_lastfm_userid,
)
from passport.backend.social.common.providers.provider import Provider


class Lastfm(Provider):
    code = 'lf'
    id = 8

    profile_links = {
        'id': 'http://www.last.fm/user/%s',
    }

    @classmethod
    def profile_link(cls, userid=None, username=None, profile_id=None, uid=None):
        # TODO Костыль, пока исправляем userid случайным образом нагенерённые
        # Музыкой.
        if is_broken_lastfm_userid(userid):
            userid = fix_lastfm_userid(userid, username)
        return super(Lastfm, cls).profile_link(userid, username)
