# -*- coding: utf-8 -*-

import re

from passport.backend.social.common.providers.provider import Provider


class MailRu(Provider):
    code = 'mr'
    id = 4

    profile_link_template = 'http://my.mail.ru/%(domain)s/%(username)s'

    @classmethod
    def profile_link(cls, userid=None, username=None, profile_id=None, uid=None):
        rv = []
        if username:
            email = cls._parse_email(username)
            if email is not None:
                user, domain = email
                rv = [cls.profile_link_template % {'domain': domain, 'username': user}]
        return rv

    @classmethod
    def _parse_email(cls, email):
        result = re.match(r'([^@]+)@([^.]+)\.ru', email)
        if result is not None:
            login, domain = result.groups()
            if domain in ('mail', 'list', 'inbox', 'bk'):
                return login, domain
