# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.utils.common import int_to_bytes


def get_randomizer():
    return LazyLoader.get_instance('randomizer')


def urandom(randomizer, length):
    return int_to_bytes(randomizer.getrandbits(length * 8), length, 'big')
