# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.misc import split_scope_string


class RefreshToken(object):
    _REQUIRED_CONSTRUCTOR_ARGS = {
        'refresh_token_id',
        'token_id',
        'value',
        'expired',
        'scopes',
    }

    def __init__(self, **kwargs):
        for arg_name in kwargs:
            if arg_name not in self._REQUIRED_CONSTRUCTOR_ARGS:
                raise TypeError("__init__() got an unexpected keyword argument '%s'" % arg_name)

        self._scopes = set()

        kwargs.setdefault('refresh_token_id', None)
        kwargs.setdefault('token_id', None)
        for arg_name in self._REQUIRED_CONSTRUCTOR_ARGS:
            setattr(self, arg_name, kwargs.get(arg_name))

    def update_token_dict_for_proxy(self, token_dict_for_proxy):
        token_dict_for_proxy['refresh'] = self.value
        token_dict_for_proxy['scope'] = ','.join(sorted(self.scopes))

    def update_from_token_dict_for_proxy(self, token_dict_for_proxy):
        value = token_dict_for_proxy.get('refresh')
        if value:
            self.value = value

        scope = token_dict_for_proxy.get('scope')
        if scope:
            self.scopes = split_scope_string(scope)

    def to_dict(self):
        return dict(
            expired=self.expired,
            refresh_token_id=self.refresh_token_id,
            scopes=self.scopes,
            token_id=self.token_id,
            value=self.value,
        )

    def set_scopes(self, value):
        if value is None:
            value = set()
        elif isinstance(value, basestring):
            value = set(split_scope_string(value))
        else:
            value = set(value)
        self._scopes = value

    def get_scopes(self):
        return self._scopes

    scopes = property(get_scopes, set_scopes)
