# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.common.misc import split_scope_string

from .db import RefreshTokenRecord
from .domain import RefreshToken


def save_refresh_token(refresh_token, db):
    record = RefreshTokenRecord.from_model(refresh_token)
    record.save(db)
    return record


def build_refresh_token_from_token_data(token_data):
    if 'refresh' not in token_data:
        return

    scopes = split_scope_string(token_data.get('scope'))
    return RefreshToken(value=token_data['refresh'], scopes=scopes, expired=None)


def find_refresh_token_by_token_id(token_id, db):
    records = RefreshTokenRecord.find_by_token_ids([token_id], db)
    assert 0 <= len(records) <= 1
    if not records:
        return
    return records[0].to_model()


def find_refresh_tokens_by_token_ids(token_ids, db):
    records = RefreshTokenRecord.find_by_token_ids(token_ids, db)
    return [r.to_model() for r in records]


def filter_refreshable_tokens(tokens, db):
    refresh_tokens = find_refresh_tokens_by_token_ids([t.token_id for t in tokens], db)
    refreshable_token_ids = {t.token_id for t in refresh_tokens}
    return [t for t in tokens if t.token_id in refreshable_token_ids]
