# -*- coding: utf-8 -*-

from datetime import datetime
import re

from passport.backend.core import Undefined
from passport.backend.core.serializers.exceptions import BaseSerializationError


TYPE_NAME_TO_DATABASE_SERIALIZER = dict()


def serialize_unixtime(timestamp):
    if timestamp is None:
        return '0000-00-00 00:00:00'
    return datetime.fromtimestamp(float(timestamp))


def serialize_datetime(timestamp):
    if timestamp is None:
        return '0000-00-00 00:00:00'
    return timestamp


def serialize_date(timestamp):
    if timestamp is None:
        return '0000-00-00'
    return timestamp


def serialize_list_of_strings(_list):
    _list = [s.replace('!', '!!').replace(',', '!,') for s in _list]
    return ','.join(_list)


def deserialize_list_of_strings(value):
    if value:
        _list = re.split('^,|(?<=[^!]),', value)
        _list = [s.replace('!,', ',') for s in _list]
        return [s.replace('!!', '!') for s in _list]
    else:
        return []


def serialize_scopes(scopes):
    return serialize_list_of_strings(sorted(scopes))


def deserialize_scopes(scopes):
    return set(deserialize_list_of_strings(scopes))


def get_not_empty_string_db_value(value):
    # Строка не пустая в том смысле, что пустая строка не сохранится в атрибут
    # или, если это обязательная колонка, сохранится в NULL.
    if value is Undefined or value is None or value == '':
        return
    if not isinstance(value, basestring):
        raise ValueSerializationError()
    return value


def get_integer_db_value(value):
    if value is Undefined or value is None:
        return
    try:
        value = int(value)
    except (TypeError, ValueError):
        raise ValueSerializationError()
    return value


def get_boolean_db_value(value):
    if value is Undefined or value is None or value is False:
        return
    if value is not True:
        raise ValueSerializationError()
    return '1'


def register_database_serializer(type_name, database_serializer_cls):
    TYPE_NAME_TO_DATABASE_SERIALIZER[type_name] = database_serializer_cls


class DatabaseQuery(object):
    def __init__(self, statement):
        self._statement = statement

    def to_query(self):
        return self._statement


class ValueSerializationError(BaseSerializationError):
    """
    Сериализуемое значение имеет неожиданную величину или тип.
    """
