# -*- coding: utf-8 -*-

from passport.backend.social.common.social_config import social_config


class Services(object):
    _instance = None
    _initialized = False
    __services = {}
    __default_sids = None

    def __new__(cls, *more):
        if cls._instance is None:
            cls._instance = super(Services, cls).__new__(cls, *more)
        return cls._instance

    def init(self):
        self.__default_sids = []
        self.__services = {}
        for service in social_config.services:
            self.__services[service['name']] = service
            self.__services[service['sid']] = service
            self.__services[str(service['sid'])] = service

            if service['default_value'] == 1 and service['sid'] not in self.__default_sids:
                self.__default_sids.append(service['sid'])

        self._initialized = True

    def get_default_sids(self):
        return self.__default_sids[:]

    @property
    def services(self):
        return self.__services

    def reinit(self):
        self.init()


services = Services()
