# -*- coding: utf-8 -*-


class Singleton(type):
    def __init__(cls, what, bases=None, dict=None):
        super(Singleton, cls).__init__(what, bases, dict)
        cls.instance = None

    def __call__(cls, *args, **kwargs):
        if cls.instance is None:
            cls.instance = super(Singleton, cls).__call__(*args, **kwargs)
        return cls.instance
