PY2_LIBRARY()

NEED_REVIEW()
OWNER(g:passport_python)

PEERDIR(
    contrib/python/Flask
    contrib/python/furl
    contrib/python/gevent
    contrib/python/gunicorn
    contrib/python/MySQL-python
    contrib/python/netaddr
    contrib/python/pyOpenSSL
    contrib/python/redis
    contrib/python/sqlalchemy/sqlalchemy-1.2
    contrib/python/urllib3
    library/python/yenv

    library/python/ylog
    library/python/deprecated/ticket_parser2

    passport/backend/contrib/oauthlib

    passport/backend/core
    passport/backend/core/builders/kolmogor/faker
    passport/backend/core/builders/passport/faker
    passport/backend/core/logging_utils/faker
    passport/backend/core/test
    passport/backend/utils/gost/cryptography
    passport/backend/utils/pkcs7
)

PY_SRCS(
    application.py
    builders/billing.py
    builders/blackbox.py
    builders/__init__.py
    builders/kolmogor.py
    builders/passport.py
    cache.py
    chrono.py
    context.py
    counter.py
    crypto.py
    datastructures.py
    db/execute.py
    db/__init__.py
    db/schemas.py
    db/types.py
    db/utils.py
    eav.py
    error_handler.py
    exception.py
    fix_lastfm.py
    fraud.py
    gpt.py
    grants.py
    gunicorn.py
    importer.py
    __init__.py
    limits.py
    middleware.py
    misc.py
    models/base.py
    models/__init__.py
    models/legacy.py
    models/parse.py
    multiprocessing.py
    oauth1/base.py
    oauth1/__init__.py
    oauth1/test.py
    oauth2/base.py
    oauth2/__init__.py
    oauth2/refresh_token.py
    oauth2/test.py
    oauth2/token.py
    pkce.py
    profile.py
    providers/Apple.py
    providers/Deezer.py
    providers/DnevnikRu.py
    providers/Esia.py
    provider_settings.py
    providers/Facebook.py
    providers/Google.py
    providers/__init__.py
    providers/Kinopoisk.py
    providers/Lastfm.py
    providers/MailRu.py
    providers/Meethue.py
    providers/Microsoft.py
    providers/MosRu.py
    providers/MtsBelarus.py
    providers/Mts.py
    providers/Odnoklassniki.py
    providers/provider.py
    providers/Telegram.py
    providers/Twitter.py
    providers/Vkontakte.py
    providers/Xiaomi.py
    providers/Yahoo.py
    providers/Yandex.py
    random.py
    redis_client.py
    refresh_token/db.py
    refresh_token/domain.py
    refresh_token/__init__.py
    refresh_token/utils.py
    serialize.py
    services_settings.py
    session.py
    settings.py
    singleton.py
    social_config.py
    social_logging.py
    states.py
    task.py
    test_client.py
    test/conf.py
    test/consts.py
    test/db.py
    test/diff.py
    test/fake_billing_api.py
    test/fake_chrono.py
    test/fake_gpt.py
    test/fake_other.py
    test/fake_passport.py
    test/fake_redis_client.py
    test/fake_throttle.py
    test/fake_useragent.py
    test/grants.py
    test/__init__.py
    test/parameterized.py
    test/sql.py
    test/test_case.py
    test/types.py
    threadpool.py
    throttler.py
    token/db.py
    token/domain.py
    token/__init__.py
    token/utils.py
    tracer.py
    tvm.py
    _urllib3.py
    useragent.py
    validators.py
    web_service.py
    yt.py
)

END()


RECURSE(
    dev_server
)


RECURSE_FOR_TESTS(
    tests
)
