# -*- coding: utf-8 -*-

from datetime import timedelta

from social_configs.settings import (
    redis_master_host,
    redis_master_password,
    redis_master_port,
)
import yenv


CELERY_IMPORTS = ('passport.backend.social.utils.tasks',)

BROKER_URL = 'redis://:%(password)s@%(host)s:%(port)s/' % dict(
    host=redis_master_host,
    port=redis_master_port,
    password=redis_master_password,
)
CELERY_RESULT_BACKEND = BROKER_URL

CELERY_SEND_EVENTS = True
CELERY_TRACK_STARTED = True
CELERY_TASK_SERIALIZER = CELERY_RESULT_SERIALIZER = 'json'
CELERY_ACCEPT_CONTENT = [CELERY_TASK_SERIALIZER]

CELERY_RESULT_PERSISTENT = True

CELERY_TASK_RESULT_EXPIRES = timedelta(hours=1)
if yenv.type == 'development':
    CELERY_TASK_RESULT_EXPIRES = timedelta(minutes=5)


CELERYBEAT_SCHEDULE = {
    'clean_db': {
        'task': 'passport.backend.social.utils.tasks.clean_db',
        'schedule': timedelta(seconds=5),
        'args': (50,),
    },
}

if yenv.type == 'testing':
    CELERYBEAT_SCHEDULE = {
        'clean_db': {
            'task': 'passport.backend.social.utils.tasks.clean_db',
            'schedule': timedelta(seconds=5),
            'args': (10,),
        },
    }
elif yenv.type == 'development':
    CELERYBEAT_SCHEDULE = {
        'ping': {
            'task': 'passport.backend.social.utils.tasks.ping',
            'schedule': timedelta(seconds=5),
        },
    }

CELERY_ANNOTATIONS = {
    'passport.backend.social.utils.tasks.eval_token_hash': {
        # 100 rps = 20 воркеров * 5 rps в проде, 10 rps = 2 воркера * 5 rps в тестинге
        'rate_limit': '22/s',
    },
}
