# -*- coding: utf-8 -*-

from datetime import timedelta
from re import compile as re_compile

from social_configs.providers import providers
from social_configs.services import services
from social_secrets import secrets
import yenv


port = 10501

social_api_host = 'api.social.yandex.ru'
if yenv.type == 'rc':
    social_api_host = 'api.social-rc.yandex.ru'
elif yenv.type == 'testing':
    social_api_host = 'api.social-test.yandex.ru'
elif yenv.type == 'development':
    social_api_host = '0.social-dev.yandex.ru'

social_broker_host_from_env = dict(
    development='0.social-dev.yandex.ru',
    production='social.yandex.ru',
    rc='social-rc.yandex.ru',
    testing='social-test.yandex.ru',
)
social_broker_host = social_broker_host_from_env['production']
if yenv.type == 'rc':
    social_broker_host = social_broker_host_from_env['rc']
elif yenv.type == 'testing':
    social_broker_host = social_broker_host_from_env['testing']
elif yenv.type == 'development':
    social_broker_host = social_broker_host_from_env['development']

redis_task_expiration_time = 10800
if yenv.type in ['testing', 'development']:
    redis_task_expiration_time = 1200

track_cookie_expiration_time = 1200
track_cookie_secure_key = secrets.track_cookie_secure_key

connection_pool_limit = 50
connection_pool_maxsize = 100
connection_pool_timeout = 1

useragent_default_timeout = 5
if yenv.type in ['testing', 'development']:
    useragent_default_timeout = 3
timeout = useragent_default_timeout

useragent_default_retries = 2
retries = useragent_default_retries

oauth_scopes_required = ['social:broker', 'yataxi:pay']

broker_stress_mode = False

broker_stress_emulator_blackbox_url = 'http://social-u2.yandex.net:11956/blackbox/'
broker_stress_emulator_provider_url = 'http://social-u2.yandex.net:11956/api/'
if yenv.type in ['testing', 'development']:
    broker_stress_emulator_blackbox_url = 'http://127.0.0.1:7469/blackbox/'
    broker_stress_emulator_provider_url = 'http://127.0.0.1:7469/api/'

broker_pool_recycle = 600

max_federation_size = 20
invalidate_billing_binding_cache = True

ping_file_path = '/opt/www/social/static/ping.html'

yandex_avatar_url_template = 'https://avatars.mds.yandex.net/get-yapic/%s/'
yandex_get_profile_url = 'https://login.yandex.ru/info'
yandex_oauth_authorize_url = 'https://oauth.yandex.ru/authorize'
yandex_oauth_token_url = 'https://oauth.yandex.ru/token'
if yenv.type in ['testing', 'development']:
    yandex_avatar_url_template = 'https://avatars.mdst.yandex.net/get-yapic/%s/'
    yandex_get_profile_url = 'https://login-test.yandex.ru/info'
    yandex_oauth_authorize_url = 'https://oauth-test.yandex.ru/authorize'
    yandex_oauth_token_url = 'https://oauth-test.yandex.ru/token'

mos_ru_broker_redirect_uri = 'https://social.yandex.ru/broker/redirect'
mos_ru_get_profile_url = 'https://login.mos.ru/sps/oauth/me'
mos_ru_oauth_authorize_url = 'https://login.mos.ru/sps/oauth/ae'
mos_ru_oauth_token_url = 'https://login.mos.ru/sps/oauth/te'
mos_ru_refresh_token_url = 'https://login.mos.ru/sps/oauth/te'
if yenv.type in ['testing', 'development']:
    mos_ru_get_profile_url = 'https://login-tech.mos.ru/sps/oauth/me'
    mos_ru_oauth_authorize_url = 'https://login-tech.mos.ru/sps/oauth/ae'
    mos_ru_oauth_token_url = 'https://login-tech.mos.ru/sps/oauth/te'
    mos_ru_refresh_token_url = 'https://login-tech.mos.ru/sps/oauth/te'

dnevnik_ru_broker_redirect_uri = 'https://social.yandex.ru/broker/redirect'
dnevnik_ru_base = 'dnevnik.ru'
if yenv.type in ['testing', 'development']:
    dnevnik_ru_base = 'staging.dnevnik.ru'
dnevnik_ru_get_profile_url = 'https://api.{}/v2.0/users/me'.format(dnevnik_ru_base)
dnevnik_ru_oauth_authorize_url = 'https://login.{}/oauth2'.format(dnevnik_ru_base)
dnevnik_ru_oauth_token_url = 'https://api.{}/v2.0/authorizations'.format(dnevnik_ru_base)
dnevnik_ru_refresh_token_url = 'https://api.{}/v2.0/authorizations'.format(dnevnik_ru_base)

allowed_retpath_schemes = [
    '^yandex',
    r'^ru\.yandex\.',
    r'^com\.yandex\.'
    r'^com\.edadeal\.',
    r'^ru\.beru\.',
    r'^ru\.kinopoisk\.',
    '^edadeal$',
    '^bluemarket$',
    r'^ai\.meteum\.',
]
if yenv.type in ['production', 'rc']:
    allowed_retpath_schemes += [
        '^maple$',
        '^kp$',
        '^yamb$',
        '^autoru$',
        '^yaevents$',
        '^yakhamovniki$',
        '^kpqs$',  # "Угадай кино"
        '^vk5524486$',  # "Снимите одежду"
        '^fb1753339288278787$',  # "Снимите одежду"
    ]
allowed_retpath_schemes = map(re_compile, allowed_retpath_schemes)

db_master_host = 'socialdb-master.yandex.net'
db_master_database = 'socialdb'
db_master_user = 'social_rw'
db_master_password = secrets.db_master_password
db_master_port = 3306
db_master_connect_timeout = 1
db_master_read_timeout = 1
db_master_reconnect_retries = 3
db_master_write_timeout = 2
# Максимум 15000 соединений, число пулов равно числу cpu 800, значение 15000 / 800
db_master_pool_size = 18
db_master_pool_timeout = db_master_connect_timeout

if yenv.type == 'testing':
    db_master_host = 'cnt-dbm-test.passport.yandex.net'
    db_master_reconnect_retries = 4
elif yenv.type == 'development':
    db_master_host = '[::1]'
    db_master_reconnect_retries = 4

db_slave_host = 'socialdb.yandex.net'
db_slave_database = 'socialdb'
db_slave_user = 'social_ro'
db_slave_password = secrets.db_slave_password
db_slave_port = 3306
db_slave_connect_timeout = 1
db_slave_read_timeout = 1
db_slave_reconnect_retries = 3
db_slave_write_timeout = 2
# Максимум 30000 соединений, число пулов равно числу cpu 800, значение 30000 / 800
db_slave_pool_size = 37
db_slave_pool_timeout = db_slave_connect_timeout

if yenv.type == 'testing':
    db_slave_host = 'cnt-dbs-test.passport.yandex.net'
    db_slave_reconnect_retries = 4
elif yenv.type == 'development':
    db_slave_host = db_master_host
    db_slave_reconnect_retries = db_master_reconnect_retries

redis_pool_size = 200
redis_reconnect_retries = 3
redis_reconnect_timeout = 0.5
redis_connection_timeout = 1

redis_master_host = 'socialdb-master.yandex.net'
redis_master_port = 6379
redis_master_password = secrets.redis_master_password

if yenv.type == 'testing':
    redis_master_host = 'social-test-s1.passport.yandex.net'
elif yenv.type == 'development':
    redis_master_host = 'localhost'

redis_slave_host = redis_master_host
redis_slave_port = redis_master_port
redis_slave_password = redis_master_password

blackbox_url = 'https://blackbox.yandex.net/blackbox'
blackbox_timeout = 0.5
blackbox_retries = 2
blackbox_availability_test_uid = 172997057

if yenv.type == 'rc':
    blackbox_url = 'https://blackbox-rc.yandex.net/blackbox'
elif yenv.type in ['testing', 'development']:
    blackbox_url = 'https://pass-test.yandex.ru/blackbox'
    blackbox_availability_test_uid = 3000153923

billing_http_api_service_token = secrets.billing_http_api_service_token
billing_http_api_url = 'https://trust-payments.paysys.yandex.net:8028'
billing_http_api_timeout = 0.5
billing_http_api_retries = 2

if yenv.type in ['testing', 'development']:
    billing_http_api_url = 'https://trust-payments-test.paysys.yandex.net:8028'

ssl_certs_path = '/etc/ssl/certs/ca-certificates.crt'

zookeeper_hosts = [
    'zk-m1.passport.yandex.net',
    'zk-s1.passport.yandex.net',
    'zk-v1.passport.yandex.net',
]
if yenv.type in ['testing', 'development']:
    zookeeper_hosts = ['zk-test.passport.yandex.net']

account_binding_offer_delays = [2592000, 2592000]
if yenv.type in ['testing', 'development']:
    account_binding_offer_delays = [60, 60]

account_binding_allow_device_id_check = True

api_tvm_keyring_config_name = '2000382-social_api_production'
api_tvm_cache_time = 60
tvm_environment = 'production'
if yenv.type in ['testing', 'development']:
    tvm_environment = 'testing'

proxy2_tvm_keyring_config_name = '2000385-social_proxy2_production'
proxy2_tvm_cache_time = 60

broker_tvm_keyring_config_name = '2000388-social_broker_production'
broker_tvm_cache_time = 60

passport_api_consumer = 'socialism'
passport_api_url = 'https://passport-internal.yandex.ru'
passport_api_timeout = 3
passport_api_retries = 3
if yenv.type in ['testing', 'development']:
    passport_api_url = 'https://passport-test-internal.yandex.ru'

yt_token = secrets.yt_token

if yenv.type in ['testing', 'development']:
    api_tvm_keyring_config_name = '2000381-social_api_testing'
    proxy2_tvm_keyring_config_name = '2000384-social_proxy2_testing'
    broker_tvm_keyring_config_name = '2000387-social_broker_testing'

kinopoisk_client_id = 'cc01d5dbc7de4925bdf07f33bd3dfd61'
kinopoisk_host = 'www.kinopoisk.ru'
if yenv.type in ['testing', 'development']:
    kinopoisk_client_id = 'ed617b6e90f14eb1889fcb041e234015'
    kinopoisk_host = 'testing.kinopoisk.ru'

# Число созданных приложений с адреса A
counter_limit_for_create_application_by_ip = 10

# Число запросов R выполненных потребителем C за 5 секунд
counter_limit_for_process_request_by_consumer = {
    ('mail', 'proxy:refresh_token'): 7000,
    ('mail-online', 'proxy:refresh_token'): 500,
}
if yenv.type in ['testing', 'development']:
    counter_limit_for_process_request_by_consumer = {
        ('local', 'proxy:refresh_token'): 5,
    }

# Когда несколько потребителей должны пользоваться общими счётчиками, будем
# отоброжать все имена этих потребителей в одно.
consumer_translation_for_counters = {
    'mail-collectors-ext': 'mail',
}

kolmogor_url = 'http://badauthdb.passport.yandex.net:9080'
if yenv.type in ['testing', 'development']:
    kolmogor_url = 'http://badauthdb-test.passport.yandex.net:9080'
kolmogor_timeout = 0.05
kolmogor_retries = 2

zora_client_id = 'socialism'
zora_url = 'http://go.zora.yandex.net:1080/'
zora_tvm_client_alias = 'gozora'

broker_retpath_grammars = [
    """
    domain = 'passport.yandex.' yandex_tld |
            'pda-passport.yandex.' yandex_tld |
            'passport-rc.yandex.' yandex_tld |
            'passport-test.yandex.' yandex_tld |
            digit+ '.passportdev.yandex.' yandex_tld |
            'passport.toloka.ai' | 'pda-passport.toloka.ai' |
            'passport.practicum.com' | 'pda-passport.practicum.com'
    path = '/auth/i-social__closer.html' |
        '/auth/social/callback_secure' |
        '/auth/social/callback' |
        '/closewebview' |
        '/profile' |
        '/registration'
    """,

    """
    domain = 'social.yandex.' yandex_tld |
        'social-test.yandex.' yandex_tld
    path = '/broker2'
    """,

    """
    domain = 'music.mts.ru' |
        'rtc-mts-music.yandex.' yandex_tld |
        'mts-' domain_bit '.crowdtest.yandex.' yandex_tld |
        'mts-music.qa.yandex.' yandex_tld |
        'rtc-mts-music.mt.yandex.' yandex_tld |
        'rtc-mts-prestable.music.' yandex_tld |
        'rtc-mts-music.qa.yandex.' yandex_tld |
        domain_bit '.mts.common.yandex.' yandex_tld
    path = '/closer.html'
    """,

    """
    domain = 'music.mts.by'
    path = '/closer.html'
    """,

    """
    domain = domain_bit '.' domain | 'music.dev.yandex.' yandex_tld
    path = '/closer.html'
    """,

    """
    domain = 'ext.kinopoisk.ru'
    path = '/auth' ('/' path_bit){3}
    """,

    """
    domain = 'reg.kinopoisk.ru' |
        'plus.kinopoisk.ru' |
        'plus.prestable.kinopoisk.ru' |
        'plus.tst.kinopoisk.ru' |
        'auth.kinopoisk.ru' |
        'auth.prestable.kinopoisk.ru' |
        'auth.tst.kinopoisk.ru'
    path = '/social-closer/'
    """,

    """
    domain = 'www.kinopoisk.ru' |
        'prestable.kinopoisk.ru' |
        'testing.kinopoisk.ru'
    path = '/social-broker/response-receiver/'
    """,

    """
    domain = 'beru.ru' |
        'www.beru.ru' |
        'pokupki.yandex.' yandex_tld |
        'market.yandex.' yandex_tld |
        'desktop-prestable.market.fslb.yandex.' yandex_tld |
        domain_bit '.market-exp-prestable.yandex.' yandex_tld |
        domain_bit '.demofslb.market.yandex.' yandex_tld
    path = '/closer.html'
    """,

    """
    domain = 'beru.ru' |
        domain_bit '.beru.ru' |
        'bringly.ru' |
        domain_bit '.bringly.ru' |
        'market.yandex.' yandex_tld |
        domain_bit '.bluemarket.fslb.beru.ru' |
        domain_bit '.demofslb.beru.ru'
    path = '/auth-redir'
    """,

    """
    domain = 'music.yandex.' yandex_tld |
        domain_bit '.music.common.yandex.' yandex_tld |
        domain_bit '.music.yandex.' yandex_tld |
        'music-' domain_bit '.crowdtest.yandex.' yandex_tld |
        domain_bit '.crowdtest.music.yandex.' yandex_tld |
        'music.mt.yandex.' yandex_tld |
        'music.qa.yandex.' yandex_tld |
        domain_bit '.music.qa.yandex.' yandex_tld
    path = '/closer.html'
    """,

    """
    domain = 'disk.yandex.' yandex_tld |
        'disk' digit* '.dsp.yandex.' yandex_tld
    path = '/close_broker.html'
    """,

    """
    domain = 'yandex.' yandex_tld |
        'www.yandex.' yandex_tld |
        'wwww.yandex.ru'
    path = '/'?
    """,

    """
    domain = 'mail.yandex.' yandex_tld
    path = '/web-api/oauth-token/liza1'
    """,

    """
    domain = 'mail-test.yandex.' yandex_tld
    path = '/'?
    """,

    """
    domain = 'yandex.' yandex_tld
    path = '/ny2018/share' ('/' path_bit){2}
    """,

    """
    domain = 'dialogs.yandex.' yandex_tld |
        'dialogs.priemka.voicetech.yandex.' yandex_tld |
        'dialogs-rc.yandex.' yandex_tld |
        'dialogs.test.voicetech.yandex.' yandex_tld |
        'priemka.dialogs.alice.yandex.' yandex_tld |
        'testing.dialogs.alice.yandex.' yandex_tld
    path = '/store/account_linking/' path_bit |
        '/developer/account-linking/redirect/'
    """,

    """
    domain = 'quasar.yandex.' yandex_tld |
        'quasar-rc.yandex.' yandex_tld
    path = '/skills/external/' path_bit '/account_linking'
    """,

    """
    domain = 'yandex.' yandex_tld |
        'hamster.yandex.' yandex_tld |
        'rctemplates-shared.hamster.yandex.' yandex_tld |
        'renderer-quasar-pull-' digit+ '.hamster.yandex.' yandex_tld |
        'local.yandex.' yandex_tld ':' digit+
    path = '/quasar/account-linking-return' |
        '/quasar/external/account-linking-complete' |
        '/iot/external/account-linking-complete'
    """,

    """
    domain = 'realty.yandex.ru'
    path = '/management-new/settings/'
    """,

    """
    domain = domain_bit '.' domain |
        'klein-stands.education.yandex.' yandex_tld
    path = '/external/reg/'
    """,

    """
    domain = 'schoolbook.yandex.' yandex_tld |
        domain_bit '.schoolbook.yandex.' yandex_tld |
        'education.yandex.' yandex_tld |
        domain_bit '.education.yandex.' yandex_tld |
        'klein.testing-crowd.crowdtest.yandex.' yandex_tld
    path = '/external/reg/'
    """,
]

if yenv.type in ['development', 'testing']:
    broker_retpath_grammars += [
        """
        domain = domain_bit '.' domain |
            'kinopoisk.ru:' digit+ |
            'kinopoisk.ru'
        """,

        """
        domain = domain_bit '.' domain |
            'yandex.' yandex_tld ':' digit+ |
            'yandex.' yandex_tld
        """,

        """
        domain = domain_bit '.' domain |
            'beru.ru:' digit+ |
            'beru.ru'
        """,

        """
        domain = domain_bit '.' domain |
            'bringly.ru:' digit+ |
            'bringly.ru'
        """,

        """
        domain = 'realty3-api-test-int.slb.vertis.yandex.net'
        path = '/2.0/user/callback/mosru'
        """,
    ]


# Максимальное число параметров у функции IN в SQL выражении, которое можно
# указывать без потери в производительности. Если указать большее число, то
# оптимизатору запросов не хватит памяти и он отключится (количество памяти
# управляется в MySQL переменной range_optimizer_max_mem_size хватит).
max_sql_in_function_values = 1000
if yenv.type == 'testing':
    max_sql_in_function_values = 5


passport_frontend_host_without_tld = 'passport.yandex.'
if yenv.type in ['testing', 'development']:
    passport_frontend_host_without_tld = 'passport-test.yandex.'


# Алгоритмы, которыми разрешено проверять подписанные JWT-токены
allowed_json_web_algorithms = frozenset(
    [
        'PS256',
        'PS384',
        'PS512',
        'RS256',
        'RS384',
        'RS512',
    ],
)


# Максимальное число проблем в одном диагностическим отчётом
diagnostics_per_report = 100

# Рекомендуемое в диагностическом отчёте минимальное TTL токена провайдера
diagnostics_recommended_token_ttl = timedelta(minutes=55).total_seconds()

# Время хранения списка собранных проблем в БД
diagnostics_ttl = timedelta(minutes=20)


general_facebook_client_id = '216570901687097'
toloka_facebook_client_id = '232663344284355'
not_yandex_facebook_client_ids = {
    toloka_facebook_client_id: 'toloka',
    '114381359143584': 'zen',
}
not_yandex_facebook_client_ids = {k: 'facebook-' + v for k, v in not_yandex_facebook_client_ids.items()}


nirvana_token = secrets.nirvana_token
reactor_url = 'https://reactor.yandex-team.ru'
# На каждую попытку пауза между попытками умножается на это число
reactor_retry_policy_backoff = 2
# Пауза между попытками (секунды)
reactor_retry_policy_delay = timedelta(minutes=2).total_seconds()
reactor_retry_policy_retries = 4


time_zone = 'Europe/Moscow'


# Сертификат, который ЕСИА использует, чтобы проверять подписи Социализма
esia_yandex_certificate = secrets.esia_yandex_certificate
# Закрытый ключ, которым Социализм подписывает запросы в ЕСИА
esia_yandex_private_key = secrets.esia_yandex_private_key
esia_yandex_private_key_password = None
esia_verify_id_token_signature = True
# Сертификат, который Социализм использует, чтобы проверять подписи ЕСИА
# http://esia.gosuslugi.ru/public/esia.zip
# Загруженный сертификат нужно преобразовать
# openssl x509 -inform der -in c.cer -out c.pem
esia_jwt_certificate = secrets.esia_jwt_certificate

# Старые имена для обратной совместимости. Можно будет удалить, когда все
# приложения перестанут ими пользоваться
esia_certificate = esia_yandex_certificate
esia_private_key = esia_yandex_private_key
esia_private_key_password = esia_yandex_private_key_password

esia_authorize_url = 'https://esia.gosuslugi.ru/aas/oauth2/ac'
if yenv.type in ['rc', 'testing', 'development']:
    esia_authorize_url = 'https://esia-portal1.test.gosuslugi.ru/aas/oauth2/ac'

esia_host = 'rt-proxy.passport.yandex.net'
if yenv.type in ['rc', 'testing', 'development']:
    esia_host = 'esia-portal1.test.gosuslugi.ru'

# Здесь не нужно указывать прокси, т.к. этот хост не для запросов
esia_real_host = 'esia.gosuslugi.ru'
if yenv.type in ['rc', 'testing', 'development']:
    esia_real_host = 'esia-portal1.test.gosuslugi.ru'

esia_token_url = 'https://rt-proxy.passport.yandex.net/aas/oauth2/te'
if yenv.type in ['rc', 'testing', 'development']:
    esia_token_url = 'https://esia-portal1.test.gosuslugi.ru/aas/oauth2/te'


environment_from_id = {
    0: 'production',
    1: 'testing',
    2: 'development',
}


def _get_environment_id():
    for eid in environment_from_id:
        env = environment_from_id[eid]
        if social_broker_host == social_broker_host_from_env.get(env):
            return eid
    else:
        return 0
environment_id = _get_environment_id()


def _build_social_broker_redirect_url_from_enviroment():
    url_from_env = dict()
    for env in social_broker_host_from_env:
        url = 'https://%s/broker/redirect' % social_broker_host_from_env[env]
        url_from_env[env] = url
    return url_from_env
social_broker_redirect_url_from_enviroment = _build_social_broker_redirect_url_from_enviroment()


def _build_domain_to_redirect_url():
    domain_to_url = {
        'www.kinopoisk.ru': 'https://www.kinopoisk.ru/social_redirect',
        '.kinopoisk.ru': 'https://www.kinopoisk.ru/social_redirect',
    }
    for tld in ['ru', 'com', 'ua', 'by', 'kz', 'net', 'com.tr']:
        redirect_url = 'https://social.yandex.%s/broker/redirect' % tld
        domain_to_url.update(
            {
                '.yandex.%s' % tld: redirect_url,
                'social.yandex.%s' % tld: redirect_url,
            },
        )
    return domain_to_url
domain_to_redirect_url = _build_domain_to_redirect_url()

max_token_response_length = 64000

find_token_by_value_hash = True

apple_team_id = '8NA98GZ448'
apple_jwt_certificate_id = 'RU6L4KQ5J2'
apple_jwt_certificate_RU6L4KQ5J2 = secrets.apple_jwt_certificate_RU6L4KQ5J2

apple_jwt_certificate_34YD4NBTYU = secrets.apple_jwt_certificate_34YD4NBTYU
apple_jwt_certificate_5HSRFD2346 = secrets.apple_jwt_certificate_5HSRFD2346
apple_jwt_certificate_6L8JT97HWD = secrets.apple_jwt_certificate_6L8JT97HWD
apple_jwt_certificate_6LPHT74597 = secrets.apple_jwt_certificate_6LPHT74597
apple_jwt_certificate_73UQWH4G92 = secrets.apple_jwt_certificate_73UQWH4G92
apple_jwt_certificate_8CH8K38YW5 = secrets.apple_jwt_certificate_8CH8K38YW5
apple_jwt_certificate_C3UV37U4RJ = secrets.apple_jwt_certificate_C3UV37U4RJ
apple_jwt_certificate_C5PH6LMZ65 = secrets.apple_jwt_certificate_C5PH6LMZ65
apple_jwt_certificate_J736X7V44M = secrets.apple_jwt_certificate_J736X7V44M
apple_jwt_certificate_JUTWQC6G3P = secrets.apple_jwt_certificate_JUTWQC6G3P
apple_jwt_certificate_L3RQ4XA7LN = secrets.apple_jwt_certificate_L3RQ4XA7LN
apple_jwt_certificate_MN54L4USZ9 = secrets.apple_jwt_certificate_MN54L4USZ9
apple_jwt_certificate_MZWWTLQFZ9 = secrets.apple_jwt_certificate_MZWWTLQFZ9
apple_jwt_certificate_N6887W5933 = secrets.apple_jwt_certificate_N6887W5933
apple_jwt_certificate_NDJ4BL2LKP = secrets.apple_jwt_certificate_NDJ4BL2LKP
apple_jwt_certificate_NDP6Z58W7S = secrets.apple_jwt_certificate_NDP6Z58W7S
apple_jwt_certificate_P636X38DR8 = secrets.apple_jwt_certificate_P636X38DR8
apple_jwt_certificate_TBS2PJ5VUW = secrets.apple_jwt_certificate_TBS2PJ5VUW
apple_jwt_certificate_TCC6Z6L838 = secrets.apple_jwt_certificate_TCC6Z6L838
apple_jwt_certificate_X52G3D29V2 = secrets.apple_jwt_certificate_X52G3D29V2
apple_jwt_certificate_ZH7T6R8FH2 = secrets.apple_jwt_certificate_ZH7T6R8FH2

__all__ = [
    'providers',
    'services',
]
