# -*- coding: utf-8 -*-

import logging

from passport.backend.social.common.chrono import now
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.yt import DEFAULT_YT_CLUSTER
from reactor_client import (
    reactor_objects,
    ReactorAPIClientV1,
    RetryPolicy as ReactorRetryPolicy,
)
from reactor_client.client_base import ReactorAPIException


REACTOR_TYPE_YT_PATH = '/yandex.reactor.artifact.YtPathArtifactValueProto'


logger = logging.getLogger(__name__)


class YtPathReactorArtifact(object):
    def __init__(self):
        self.artifact = None
        self.yt_cluster = DEFAULT_YT_CLUSTER
        self.yt_path = None

    @classmethod
    def build(cls, artifact, yt_path):
        self = YtPathReactorArtifact()
        self.artifact = artifact
        self.yt_path = yt_path
        return self

    @property
    def identifier(self):
        return reactor_objects.ArtifactIdentifier(
            namespace_identifier=reactor_objects.NamespaceIdentifier(self.artifact),
        )

    def instantiate(self):
        try:
            self.reactor_client.artifact_instance.instantiate(
                artifact_identifier=self.identifier,
                create_if_not_exist=True,
                metadata=self.metadata,
                user_time=now(),
            )
        except ReactorAPIException:
            logger.debug(
                'Unable to instantiate Yandex.Reactor artifact: %s' %
                self.identifier.namespace_identifier.namespace_path,
                exc_info=True,
            )

    @property
    def metadata(self):
        return reactor_objects.Metadata(
            dict_obj=dict(cluster=self.yt_cluster, path=self.yt_path),
            type_=REACTOR_TYPE_YT_PATH,
        )

    @property
    def reactor_client(self):
        return ReactorAPIClientV1(
            base_url=social_config.reactor_url,
            retry_policy=ReactorRetryPolicy(
                backoff=social_config.reactor_retry_policy_backoff,
                delay=social_config.reactor_retry_policy_delay,
                tries=social_config.reactor_retry_policy_retries,
            ),
            token=social_config.nirvana_token,
        )
