# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging
import logging.config
import os
from os import path
import sys

from flask import Flask
from passport.backend.social.common.social_config import social_config
from passport.backend.social.common.social_logging import SocialFormatter
from passport.backend.social.metrics.utils import (
    discover_modules,
    discover_subclasses,
)
import passport.backend.social.metrics.views
from passport.backend.social.metrics.views.base import MetricsView


logger = logging.getLogger(__name__)


def create_app():
    app = Flask(__name__)

    for metrics_view in discover_metrics_views():
        url_path = '/metrics/' + metrics_view.__module__.rsplit('.', 1)[1]
        logger.info('Discovered view: GET %s' % url_path)
        app.add_url_rule(
            url_path,
            methods=['GET'],
            view_func=metrics_view.as_view()
        )
    return app


def discover_metrics_views():
    metrics_views = list()
    for module in discover_modules(passport.backend.social.metrics.views):
        metrics_views.extend(discover_subclasses(module, MetricsView))
    return metrics_views


def prepare_interprocess_environment():
    logging_settings_init()
    social_config.init()


def prepare_intraprocess_environment():
    # Пока эта функция ничего не делает. Она нужна, чтобы исполнить контракт
    # с функцией passport.backend.social.common.dev_server.run_dev
    return


def logging_settings_init():
    root_handlers = {'metrics.error'}
    if not os.environ.get('SYSTEM_WIDE_SOCIAL_METRICS'):
        root_handlers.add('console')

    if os.environ.get('SYSTEM_WIDE_SOCIAL_METRICS'):
        LOG_PATH = '/var/log/yandex/socialism'
    else:
        LOG_PATH = '.'

    conf = {
        'version': 1,
        'disable_existing_loggers': False,
        'root': {
            'handlers': root_handlers,
            'level': 'DEBUG',
        },
        'formatters': {
            'default': {
                '()': SocialFormatter,
                'fmt': '[%(asctime)s][%(levelname)s] %(message)s',
                'context': object(),
            },
        },
        'handlers': {
            'console': {
                'class': 'logging.StreamHandler',
                'formatter': 'default',
                'level': 'DEBUG',
                'stream': sys.stdout,
            },
            'metrics.error': {
                'class': 'passport.backend.social.common.social_logging.OsFileHandler',
                'formatter': 'default',
                'filename': path.join(LOG_PATH, 'social-metrics.error.log'),
                'level': 'ERROR',
            },
        },
    }
    logging.captureWarnings(True)
    logging.config.dictConfig(conf)
