# -*- coding: utf-8 -*-

from __future__ import absolute_import

from multiprocessing import cpu_count
import sys

from passport.backend.social.common.gunicorn import Application
from passport.backend.social.common.importer import (
    install_file_system_importer,
    install_python_path2,
)


name = 'social-metrics'

cfg = dict(
    bind='127.0.0.1:7000',
    app_uri='passport.backend.social.metrics.wsgi:app',
    worker_class='gthread',
    threads=100,
    errorlog='/var/log/yandex/socialism/%s.gunicorn.error.log' % name,
    accesslog='/var/log/yandex/socialism/%s.gunicorn.access.log' % name,
    loglevel='INFO',
    workers=cpu_count(),
    timeout=30,
)


def main():
    install_python_path2()
    install_file_system_importer()
    sys.exit(Application(cfg).run())


if __name__ == '__main__':
    main()
