# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from importlib import import_module
import os
from pkgutil import walk_packages
import ssl
import urllib2


def ping(host, url, timeout, check_hostname=True):
    try:
        request = urllib2.Request(url)
        request.add_header('Host', host)

        extra = dict()
        if (
            url.startswith('https://') and
            hasattr(ssl, 'create_default_context')
        ):
            context = ssl.create_default_context()
            context.check_hostname = check_hostname
            extra.update(context=context)

        result = urllib2.urlopen(request, timeout=timeout, **extra)
        return result.read().decode('utf-8').strip()
    except urllib2.URLError:
        return ''


def get_frontend_host():
    return dict(
        testing='social-test.yandex.ru',
        rc='social-rc.yandex.ru',
        production='social.yandex.ru',
        development='0.social-dev.yandex.ru',
    ).get(get_yenv())


def get_api_host():
    return dict(
        testing='api.social-test.yandex.ru',
        rc='social-rc.yandex.ru',
        production='api.social.yandex.ru',
    ).get(get_yenv())


def get_yenv():
    try:
        env_type = open('/etc/yandex/environment.type').read().decode('utf-8').strip()
    except IOError:
        env_type = None
    try:
        env_name = open('/etc/yandex/environment.name').read().decode('utf-8').strip()
    except IOError:
        env_name = None
    if env_name == 'rc':
        env_type = 'rc'
    return env_type


def is_host_enabled():
    ping_stat = os.stat('/opt/www/social/static/ping.html')
    return bool(ping_stat.st_mode & 0777)


def discover_modules(package):
    modules = []
    for _, name, is_pkg in walk_packages(package.__path__):
        assert not is_pkg
        modules.append(
            import_module(
                '.' + name,
                package.__name__,
            ),
        )
    return modules


def discover_subclasses(module, superclass):
    module_attrs = [getattr(module, n) for n in dir(module)]
    subclasses = []
    for attr in module_attrs:
        try:
            if attr is not superclass and issubclass(attr, superclass):
                subclasses.append(attr)
        except TypeError:
            pass
    return subclasses
