# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import flask.views


class MetricsView(flask.views.View):
    def dispatch_request(self):
        lines = self.process_request()
        return '\n'.join(lines) + '\n'

    @classmethod
    def as_view(cls, name=None, *args, **kwargs):
        name = name or cls.__name__
        return super(MetricsView, cls).as_view(name, *args, **kwargs)
