# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import os

from passport.backend.social.metrics.views.base import MetricsView


# https://www.kernel.org/doc/Documentation/block/stat.txt
attrs = [
    'read_ios',
    'read_merges',
    'read_sectors',
    'read_ticks',
    'write_ios',
    'write_merges',
    'write_sectors',
    'write_ticks',
]
attrs = {s: i for i, s in enumerate(attrs)}

io_ticks = 9


class IoMetrics(MetricsView):
    def process_request(object):
        # Список дисков
        with os.popen('ls -1 /sys/block | egrep "^[sv]d*"') as f:
            hdds = f.read().split('\n')
            hdds = [h for h in hdds if h]

        response = ['prj = passport.social']

        for hdd in hdds:
            stats = open('/sys/block/' + hdd + '/stat').read().split()

            # Нормализация r/w io устройства в %
            value = stats[io_ticks]
            response.append('social-io-runtime.usage_percent.{0}._txxv = {1} * 0.1; ndiffs'.format(hdd, value))

            for attr in attrs:
                value = stats[attrs[attr]]
                response.append('social-io-runtime.{0}.{1}._tmmv = {2}; ndiffs'.format(attr, hdd, value))

        return response
