# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.metrics.utils import (
    get_api_host,
    is_host_enabled,
    ping,
)
from passport.backend.social.metrics.views.base import MetricsView


class SocialApiPingHttpMetrics(MetricsView):
    def process_request(object):
        host = get_api_host()
        if host and is_host_enabled():
            ping_result = ping(
                host=host,
                url='http://localhost/api/ping',
                timeout=0.1,
            )
            metric = int(ping_result == 'Pong')
        else:
            metric = 0

        return [
            "prj = passport.social",
            "ttl = 5",
            "social-api-runtime.ping_http_ok_count._tmmn = %s" % metric,
        ]
