# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from passport.backend.social.metrics.utils import (
    get_api_host,
    is_host_enabled,
    ping,
)
from passport.backend.social.metrics.views.base import MetricsView


class SocialBrokerPingHttpsMetrics(MetricsView):
    def process_request(object):
        host = get_api_host()
        if host and is_host_enabled():
            ping_result = ping(
                host=host,
                url='https://localhost/brokerapi/ping?check=blackbox,db',
                timeout=0.1,
                check_hostname=False,
            )
            metric = int(ping_result == 'Pong')
        else:
            metric = 0

        return [
            "prj = passport.social",
            "ttl = 5",
            "social-broker-runtime.ping_https_ok_count._tmmn = %s" % metric,
        ]
