# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import (
    date,
    datetime,
    time,
    timedelta,
)
from os import path

from passport.backend.social.common.social_config import social_config
from passport.backend.social.metrics.utils import get_yenv
from passport.backend.social.metrics.views.base import MetricsView
import yenv
from yt import wrapper as yt


# Если число строк в таблице окажется меньше этого значения, то сработает
# мониторинг.
ROW_COUNT_MIN_THRESHOLD = 1000

TARGET_DIR = '//home/passport/%s/socialism/crypta-dump' % yenv.type


class SocialDumpersCryptaLogMetrics(MetricsView):
    def process_request(object):
        if get_yenv() == 'production':
            yt.config['token'] = social_config.yt_token
            yt.config['proxy']['retries']['count'] = 3
            yt.config['proxy']['request_timeout'] = 2000
            yt.config.set_proxy('hahn')

            today = date.today()
            if datetime.now() < datetime.combine(today, time(9, 0, 0)):
                today = today - timedelta(days=1)

            target_path = path.join(TARGET_DIR, str(today))

            try:
                metric = 0
                if yt.exists(target_path):
                    row_count = yt.get('%s/@row_count' % target_path)
                    if row_count >= ROW_COUNT_MIN_THRESHOLD:
                        metric = 1
            except (yt.YtError, IOError):
                metric = 0
        else:
            metric = 0

        return [
            'prj = passport.social',
            'ttl = 300',
            'social-dumpers-runtime.is_crypta_log_dumped._txxn = %s' % metric,
        ]
